<?php
/**
 * --------------------------------------------------------------------------------
 * Payment Plugin - Paymill
 * --------------------------------------------------------------------------------
 * @package     Joomla 2.5 -  3.x
 * @subpackage  J2Store
 * @author      Paymill
 * @copyright   Copyright (c) Paymill
 * @license     GNU/GPL license: http://www.gnu.org/licenses/gpl-2.0.html
 * --------------------------------------------------------------------------------
 *
 * */


namespace Paymill\Models\Request;
// No direct access
defined('_JEXEC') or die('Restricted access');
/**
 * Transaction Model
 * A transaction is the charging of a credit card or a direct debit.
 * In this case you need a new transaction object with either a valid token, payment, client + payment or
 * preauthorization. Every transaction has a unique identifier which will be generated by Paymill to identify every
 * transaction. You can issue/create, list and display transactions in detail. Refunds can be done in an extra entity.
 * @tutorial https://paymill.com/de-de/dokumentation/referenz/api-referenz/#document-transactions
 */
class Transaction extends Base
{
    /**
     * @var string
     */
    private $_amount;

    /**
     * @var string
     */
    private $_description;

    /**
     * @var string
     */
    private $_currency;

    /**
     * @var string
     */
    private $_payment;

    /**
     * @var string
     */
    private $_client = null;

    /**
     * @var string
     */
    private $_preauthorization;

    /**
     * @var string
     */
    private $_token;

    /**
     * @var string
     */
    private $_feeAmount;

    /**
     * @var string
     */
    private $_feePayment;

    /**
     * @var string
     */
    private $_feeCurrency;

    /**
     * Creates an instance of the transaction request model
     */
    function __construct()
    {
        $this->_serviceResource = 'Transactions/';
    }

    /**
     * Returns the 'real' amount
     * @return string
     */
    public function getAmount()
    {
        return $this->_amount;
    }

    /**
     * Sets the 'real' amount for the transaction.
     * The number musst be in the smallest currency unit and will be saved as a string
     * @param string $amount
     * @return \Paymill\Models\Request\Transaction
     */
    public function setAmount($amount)
    {
        $this->_amount = $amount;
        return $this;
    }

    /**
     * Returns the transaction description
     * @return string
     */
    public function getDescription()
    {
        return $this->_description;
    }

    /**
     * Sets the transaction description
     * @param string $description
     * @return \Paymill\Models\Request\Transaction
     */
    public function setDescription($description)
    {
        $this->_description = $description;
        return $this;
    }

    /**
     * Returns the currency
     * @return string
     */
    public function getCurrency()
    {
        return $this->_currency;
    }

    /**
     * Sets the currency
     * @param string $currency
     * @return \Paymill\Models\Request\Transaction
     */
    public function setCurrency($currency)
    {
        $this->_currency = $currency;
        return $this;
    }

    /**
     * Returns the identifier of the payment associated with the transaction
     * @return string
     */
    public function getPayment()
    {
        return $this->_payment;
    }

    /**
     * Sets the identifier of the Payment for the transcation
     * @param string $payment
     * @return \Paymill\Models\Request\Transaction
     */
    public function setPayment($payment)
    {
        $this->_payment = $payment;
        return $this;
    }

    /**
     * Returns the identifier of the Client associated with the transaction. If no client is available null will be returned
     * @return string|null
     */
    public function getClient()
    {
        return $this->_client;
    }

    /**
     * Sets the identifier of the Client for the transaction
     * @param string $client
     * @return \Paymill\Models\Request\Transaction
     */
    public function setClient($client)
    {
        $this->_client = $client;
        return $this;
    }

    /**
     * Returns the identifier of the Preauthorization associated with the transaction. If no preAuth is available null will be returned
     * @return string|null
     */
    public function getPreauthorization()
    {
        return $this->_preauthorization;
    }

    /**
     * Sets the identifier of the Preauthorization for the transaction
     * @param string $preauthorization
     * @return \Paymill\Models\Request\Transaction
     */
    public function setPreauthorization($preauthorization)
    {
        $this->_preauthorization = $preauthorization;
        return $this;
    }

    /**
     * Returns the FeeAmount
     * Fee included in the transaction amount (set by a connected app). Mandatory if feePayment is set
     * @return integer
     */
    public function getFeeAmount()
    {
        return $this->_feeAmount;
    }

    /**
     * Sets the Fee included in the transaction amount (set by a connected app).
     * @param integer $feeAmount
     * @return \Paymill\Models\Request\Transaction
     */
    public function setFeeAmount($feeAmount)
    {
        $this->_feeAmount = $feeAmount;
        return $this;
    }

    /**
     * Returns the identifier of the payment from which the fee will be charged (creditcard-object or directdebit-object).
     * @return string
     */
    public function getFeePayment()
    {
        return $this->_feePayment;
    }

    /**
     * Sets the identifier of the payment from which the fee will be charged (creditcard-object or directdebit-object).
     * @param string $feePayment
     * @return \Paymill\Models\Request\Transaction
     */
    public function setFeePayment($feePayment)
    {
        $this->_feePayment = $feePayment;
        return $this;
    }

    /**
     * Set the currency which should be used for collecting the given fee
     * @param string $feeCurrency (e.g. EUR, USD ...)
     * @return \Paymill\Models\Response\Transaction
     */
    public function setFeeCurrency($feeCurrency)
    {
        $this->_feeCurrency = $feeCurrency;
        return $this;

    }

    /**
     * returns the set fee currency which is used for the fee collection
     * @return string
     */
    public function getFeeCurrency()
    {
        return $this->_feeCurrency;
    }



    /**
     * Returns the  token generated through our JavaScript-Bridge.
     * When this parameter is used, none of the following should be used: payment, preauthorization.
     * @return string
     */
    public function getToken()
    {
        return $this->_token;
    }

    /**
     * Sets the token generated through our JavaScript-Bridge.
     * When this parameter is used, none of the following should be used: payment, preauthorization.
     * @param string $token
     * @return \Paymill\Models\Request\Transaction
     */
    public function setToken($token)
    {
        $this->_token = $token;
        return $this;
    }

    /**
     * Returns an array of parameters customized for the argumented methodname
     * @param string $method
     * @return array
     */
    public function parameterize($method)
    {
        $parameterArray = array();
        switch ($method) {
            case 'create':
                if (!is_null($this->getPreauthorization())) {
                    $parameterArray['preauthorization'] = $this->getPreauthorization();
                } elseif (!is_null($this->getPayment())) {
                    $parameterArray['payment'] = $this->getPayment();
                } else {
                    $parameterArray['token'] = $this->getToken();
                }
                $parameterArray['amount'] = $this->getAmount();
                $parameterArray['currency'] = $this->getCurrency();
                $parameterArray['description'] = $this->getDescription();
                $parameterArray['client'] = $this->getClient();
                if (!is_null($this->getFeeAmount())) {
                    $parameterArray['fee_amount'] = $this->getFeeAmount();
                }
                if (!is_null($this->getFeePayment())) {
                    $parameterArray['fee_payment'] = $this->getFeePayment();
                }
                if (!is_null($this->getFeeCurrency())) {
                    $parameterArray['fee_currency'] = $this->getFeeCurrency();
                }
                break;
            case 'update':
                $parameterArray['description'] = $this->getDescription();
                break;
            case 'getAll':
                $parameterArray = $this->getFilter();
                break;
            case 'getOne':
                $parameterArray['count'] = 1;
                $parameterArray['offset'] = 0;
                break;
            case 'delete':
                break;
        }

        return $parameterArray;
    }
}
