<?php
/**
 * @package         Regular Labs Library
 * @version         17.9.1430
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://www.regularlabs.com
 * @copyright       Copyright © 2017 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

if ( ! is_file(JPATH_LIBRARIES . '/regularlabs/autoload.php'))
{
	return;
}

require_once JPATH_LIBRARIES . '/regularlabs/autoload.php';

use RegularLabs\Library\Form as RL_Form;
use RegularLabs\Library\RegEx as RL_RegEx;

class JFormFieldRL_Geo extends \RegularLabs\Library\Field
{
	public $type = 'Geo';

	protected function getInput()
	{
		$this->params = $this->element->attributes();

		if ( ! is_array($this->value))
		{
			$this->value = explode(',', $this->value);
		}

		$group     = $this->get('group', 'countries');
		$use_names = $this->get('use_names');

		$options = [];
		foreach ($this->{$group} as $key => $val)
		{
			if ( ! $val)
			{
				$options[] = JHtml::_('select.option', '-', '&nbsp;', 'value', 'text', true);
				continue;
			}

			if ($key['0'] == '-')
			{
				$options[] = JHtml::_('select.option', '-', $val, 'value', 'text', true);
				continue;
			}

			$val       = RL_Form::prepareSelectItem($val);
			$options[] = JHtml::_('select.option', $use_names ? $val : $key, $val);
		}

		$size     = (int) $this->get('size');
		$multiple = $this->get('multiple');

		return $this->selectListSimple($options, $this->name, $this->value, $this->id, $size, $multiple);
	}

	public $continents = [
		'AF' => 'Africa',
		'AS' => 'Asia',
		'EU' => 'Europe',
		'NA' => 'North America',
		'SA' => 'South America',
		'OC' => 'Oceania',
		'AN' => 'Antarctica',
	];

	public $countries = [
		'AF' => "Afghanistan",
		'AX' => "Aland Islands",
		'AL' => "Albania",
		'DZ' => "Algeria",
		'AS' => "American Samoa",
		'AD' => "Andorra",
		'AO' => "Angola",
		'AI' => "Anguilla",
		'AQ' => "Antarctica",
		'AG' => "Antigua and Barbuda",
		'AR' => "Argentina",
		'AM' => "Armenia",
		'AW' => "Aruba",
		'AU' => "Australia",
		'AT' => "Austria",
		'AZ' => "Azerbaijan",
		'BS' => "Bahamas",
		'BH' => "Bahrain",
		'BD' => "Bangladesh",
		'BB' => "Barbados",
		'BY' => "Belarus",
		'BE' => "Belgium",
		'BZ' => "Belize",
		'BJ' => "Benin",
		'BM' => "Bermuda",
		'BT' => "Bhutan",
		'BO' => "Bolivia",
		'BA' => "Bosnia and Herzegovina",
		'BW' => "Botswana",
		'BV' => "Bouvet Island",
		'BR' => "Brazil",
		'IO' => "British Indian Ocean Territory",
		'BN' => "Brunei Darussalam",
		'BG' => "Bulgaria",
		'BF' => "Burkina Faso",
		'BI' => "Burundi",
		'KH' => "Cambodia",
		'CM' => "Cameroon",
		'CA' => "Canada",
		'CV' => "Cape Verde",
		'KY' => "Cayman Islands",
		'CF' => "Central African Republic",
		'TD' => "Chad",
		'CL' => "Chile",
		'CN' => "China",
		'CX' => "Christmas Island",
		'CC' => "Cocos (Keeling) Islands",
		'CO' => "Colombia",
		'KM' => "Comoros",
		'CG' => "Congo",
		'CD' => "Congo, The Democratic Republic of the",
		'CK' => "Cook Islands",
		'CR' => "Costa Rica",
		'CI' => "Cote d'Ivoire",
		'HR' => "Croatia",
		'CU' => "Cuba",
		'CY' => "Cyprus",
		'CZ' => "Czech Republic",
		'DK' => "Denmark",
		'DJ' => "Djibouti",
		'DM' => "Dominica",
		'DO' => "Dominican Republic",
		'EC' => "Ecuador",
		'EG' => "Egypt",
		'SV' => "El Salvador",
		'GQ' => "Equatorial Guinea",
		'ER' => "Eritrea",
		'EE' => "Estonia",
		'ET' => "Ethiopia",
		'FK' => "Falkland Islands (Malvinas)",
		'FO' => "Faroe Islands",
		'FJ' => "Fiji",
		'FI' => "Finland",
		'FR' => "France",
		'GF' => "French Guiana",
		'PF' => "French Polynesia",
		'TF' => "French Southern Territories",
		'GA' => "Gabon",
		'GM' => "Gambia",
		'GE' => "Georgia",
		'DE' => "Germany",
		'GH' => "Ghana",
		'GI' => "Gibraltar",
		'GR' => "Greece",
		'GL' => "Greenland",
		'GD' => "Grenada",
		'GP' => "Guadeloupe",
		'GU' => "Guam",
		'GT' => "Guatemala",
		'GG' => "Guernsey",
		'GN' => "Guinea",
		'GW' => "Guinea-Bissau",
		'GY' => "Guyana",
		'HT' => "Haiti",
		'HM' => "Heard Island and McDonald Islands",
		'VA' => "Holy See (Vatican City State)",
		'HN' => "Honduras",
		'HK' => "Hong Kong",
		'HU' => "Hungary",
		'IS' => "Iceland",
		'IN' => "India",
		'ID' => "Indonesia",
		'IR' => "Iran, Islamic Republic of",
		'IQ' => "Iraq",
		'IE' => "Ireland",
		'IM' => "Isle of Man",
		'IL' => "Israel",
		'IT' => "Italy",
		'JM' => "Jamaica",
		'JP' => "Japan",
		'JE' => "Jersey",
		'JO' => "Jordan",
		'KZ' => "Kazakhstan",
		'KE' => "Kenya",
		'KI' => "Kiribati",
		'KP' => "Korea, Democratic People's Republic of",
		'KR' => "Korea, Republic of",
		'KW' => "Kuwait",
		'KG' => "Kyrgyzstan",
		'LA' => "Lao People's Democratic Republic",
		'LV' => "Latvia",
		'LB' => "Lebanon",
		'LS' => "Lesotho",
		'LR' => "Liberia",
		'LY' => "Libyan Arab Jamahiriya",
		'LI' => "Liechtenstein",
		'LT' => "Lithuania",
		'LU' => "Luxembourg",
		'MO' => "Macao",
		'MK' => "Macedonia",
		'MG' => "Madagascar",
		'MW' => "Malawi",
		'MY' => "Malaysia",
		'MV' => "Maldives",
		'ML' => "Mali",
		'MT' => "Malta",
		'MH' => "Marshall Islands",
		'MQ' => "Martinique",
		'MR' => "Mauritania",
		'MU' => "Mauritius",
		'YT' => "Mayotte",
		'MX' => "Mexico",
		'FM' => "Micronesia, Federated States of",
		'MD' => "Moldova, Republic of",
		'MC' => "Monaco",
		'MN' => "Mongolia",
		'ME' => "Montenegro",
		'MS' => "Montserrat",
		'MA' => "Morocco",
		'MZ' => "Mozambique",
		'MM' => "Myanmar",
		'NA' => "Namibia",
		'NR' => "Nauru",
		'NP' => "Nepal",
		'NL' => "Netherlands",
		'AN' => "Netherlands Antilles",
		'NC' => "New Caledonia",
		'NZ' => "New Zealand",
		'NI' => "Nicaragua",
		'NE' => "Niger",
		'NG' => "Nigeria",
		'NU' => "Niue",
		'NF' => "Norfolk Island",
		'MP' => "Northern Mariana Islands",
		'NO' => "Norway",
		'OM' => "Oman",
		'PK' => "Pakistan",
		'PW' => "Palau",
		'PS' => "Palestinian Territory",
		'PA' => "Panama",
		'PG' => "Papua New Guinea",
		'PY' => "Paraguay",
		'PE' => "Peru",
		'PH' => "Philippines",
		'PN' => "Pitcairn",
		'PL' => "Poland",
		'PT' => "Portugal",
		'PR' => "Puerto Rico",
		'QA' => "Qatar",
		'RE' => "Reunion",
		'RO' => "Romania",
		'RU' => "Russian Federation",
		'RW' => "Rwanda",
		'SH' => "Saint Helena",
		'KN' => "Saint Kitts and Nevis",
		'LC' => "Saint Lucia",
		'PM' => "Saint Pierre and Miquelon",
		'VC' => "Saint Vincent and the Grenadines",
		'WS' => "Samoa",
		'SM' => "San Marino",
		'ST' => "Sao Tome and Principe",
		'SA' => "Saudi Arabia",
		'SN' => "Senegal",
		'RS' => "Serbia",
		'SC' => "Seychelles",
		'SL' => "Sierra Leone",
		'SG' => "Singapore",
		'SK' => "Slovakia",
		'SI' => "Slovenia",
		'SB' => "Solomon Islands",
		'SO' => "Somalia",
		'ZA' => "South Africa",
		'GS' => "South Georgia and the South Sandwich Islands",
		'ES' => "Spain",
		'LK' => "Sri Lanka",
		'SD' => "Sudan",
		'SR' => "Suriname",
		'SJ' => "Svalbard and Jan Mayen",
		'SZ' => "Swaziland",
		'SE' => "Sweden",
		'CH' => "Switzerland",
		'SY' => "Syrian Arab Republic",
		'TW' => "Taiwan",
		'TJ' => "Tajikistan",
		'TZ' => "Tanzania, United Republic of",
		'TH' => "Thailand",
		'TL' => "Timor-Leste",
		'TG' => "Togo",
		'TK' => "Tokelau",
		'TO' => "Tonga",
		'TT' => "Trinidad and Tobago",
		'TN' => "Tunisia",
		'TR' => "Turkey",
		'TM' => "Turkmenistan",
		'TC' => "Turks and Caicos Islands",
		'TV' => "Tuvalu",
		'UG' => "Uganda",
		'UA' => "Ukraine",
		'AE' => "United Arab Emirates",
		'GB' => "United Kingdom",
		'US' => "United States",
		'UM' => "United States Minor Outlying Islands",
		'UY' => "Uruguay",
		'UZ' => "Uzbekistan",
		'VU' => "Vanuatu",
		'VE' => "Venezuela",
		'VN' => "Vietnam",
		'VG' => "Virgin Islands, British",
		'VI' => "Virgin Islands, U.S.",
		'WF' => "Wallis and Futuna",
		'EH' => "Western Sahara",
		'YE' => "Yemen",
		'ZM' => "Zambia",
		'ZW' => "Zimbabwe",
	];

	public $regions = [
		'-AU'    => "Australia",
		'AU-ACT' => "Australia: Australian Capital Territory",
		'AU-NSW' => "Australia: New South Wales",
		'AU-NT'  => "Australia: Northern Territory",
		'AU-QLD' => "Australia: Queensland",
		'AU-SA'  => "Australia: South Australia",
		'AU-TAS' => "Australia: Tasmania",
		'AU-VIC' => "Australia: Victoria",
		'AU-WA'  => "Australia: Western Australia",

		'--BE'   => "", '-BE' => "Belgium",
		'BE-VAN' => "Belgium: Antwerpen",
		'BE-WBR' => "Belgium: Brabant Wallon",
		'BE-BRU' => "Belgium: Brussels-Capital Region",
		'BE-WHT' => "Belgium: Hainaut",
		'BE-WLG' => "Belgium: Liege",
		'BE-VLI' => "Belgium: Limburg",
		'BE-WLX' => "Belgium: Luxembourg, Luxemburg",
		'BE-WNA' => "Belgium: Namur",
		'BE-VOV' => "Belgium: Oost-Vlaanderen",
		'BE-VBR' => "Belgium: Vlaams-Brabant",
		'BE-VWV' => "Belgium: West-Vlaanderen",

		'--BR'  => "", '-BR' => "Brazil",
		'BR-AC' => "Brazil: Acre",
		'BR-AL' => "Brazil: Alagoas",
		'BR-AP' => "Brazil: Amapá",
		'BR-AM' => "Brazil: Amazonas",
		'BR-BA' => "Brazil: Bahia",
		'BR-CE' => "Brazil: Ceará",
		'BR-DF' => "Brazil: Distrito Federal",
		'BR-ES' => "Brazil: Espírito Santo",
		'BR-FN' => "Brazil: Fernando de Noronha",
		'BR-GO' => "Brazil: Goiás",
		'BR-MA' => "Brazil: Maranhão",
		'BR-MT' => "Brazil: Mato Grosso",
		'BR-MS' => "Brazil: Mato Grosso do Sul",
		'BR-MG' => "Brazil: Minas Gerais",
		'BR-PR' => "Brazil: Paraná",
		'BR-PB' => "Brazil: Paraíba",
		'BR-PA' => "Brazil: Pará",
		'BR-PE' => "Brazil: Pernambuco",
		'BR-PI' => "Brazil: Piauí",
		'BR-RN' => "Brazil: Rio Grande do Norte",
		'BR-RS' => "Brazil: Rio Grande do Sul",
		'BR-RJ' => "Brazil: Rio de Janeiro",
		'BR-RO' => "Brazil: Rondônia",
		'BR-RR' => "Brazil: Roraima",
		'BR-SC' => "Brazil: Santa Catarina",
		'BR-SE' => "Brazil: Sergipe",
		'BR-SP' => "Brazil: São Paulo",
		'BR-TO' => "Brazil: Tocantins",

		'--CA'  => "", '-CA' => "Canada",
		'CA-AB' => "Canada: Alberta",
		'CA-BC' => "Canada: British Columbia",
		'CA-MB' => "Canada: Manitoba",
		'CA-NB' => "Canada: New Brunswick",
		'CA-NL' => "Canada: Newfoundland and Labrador",
		'CA-NT' => "Canada: Northwest Territories",
		'CA-NS' => "Canada: Nova Scotia",
		'CA-NU' => "Canada: Nunavut",
		'CA-ON' => "Canada: Ontario",
		'CA-PE' => "Canada: Prince Edward Island",
		'CA-QC' => "Canada: Quebec",
		'CA-SK' => "Canada: Saskatchewan",
		'CA-YT' => "Canada: Yukon Territory",

		'--CN'  => "", '-CN' => "China",
		'CN-34' => "China: Anhui",
		'CN-92' => "China: Aomen (Macau)",
		'CN-11' => "China: Beijing",
		'CN-50' => "China: Chongqing",
		'CN-35' => "China: Fujian",
		'CN-62' => "China: Gansu",
		'CN-44' => "China: Guangdong",
		'CN-45' => "China: Guangxi",
		'CN-52' => "China: Guizhou",
		'CN-46' => "China: Hainan",
		'CN-13' => "China: Hebei",
		'CN-23' => "China: Heilongjiang",
		'CN-41' => "China: Henan",
		'CN-42' => "China: Hubei",
		'CN-43' => "China: Hunan",
		'CN-32' => "China: Jiangsu",
		'CN-36' => "China: Jiangxi",
		'CN-22' => "China: Jilin",
		'CN-21' => "China: Liaoning",
		'CN-15' => "China: Nei Mongol",
		'CN-64' => "China: Ningxia",
		'CN-63' => "China: Qinghai",
		'CN-61' => "China: Shaanxi",
		'CN-37' => "China: Shandong",
		'CN-31' => "China: Shanghai",
		'CN-14' => "China: Shanxi",
		'CN-51' => "China: Sichuan",
		'CN-71' => "China: Taiwan",
		'CN-12' => "China: Tianjin",
		'CN-91' => "China: Xianggang (Hong-Kong)",
		'CN-65' => "China: Xinjiang",
		'CN-54' => "China: Xizang",
		'CN-53' => "China: Yunnan",
		'CN-33' => "China: Zhejiang",

		'--EG'   => "", '-EG' => "Egypt",
		'EG-DK'  => "Egypt: Ad Daqahlīyah",
		'EG-BA'  => "Egypt: Al Bahr al Ahmar",
		'EG-BH'  => "Egypt: Al Buhayrah",
		'EG-FYM' => "Egypt: Al Fayyūm",
		'EG-GH'  => "Egypt: Al Gharbīyah",
		'EG-ALX' => "Egypt: Al Iskandarīyah",
		'EG-IS'  => "Egypt: Al Ismā`īlīyah",
		'EG-GZ'  => "Egypt: Al Jīzah",
		'EG-MN'  => "Egypt: Al Minyā",
		'EG-MNF' => "Egypt: Al Minūfīyah",
		'EG-KB'  => "Egypt: Al Qalyūbīyah",
		'EG-C'   => "Egypt: Al Qāhirah",
		'EG-WAD' => "Egypt: Al Wādī al Jadīd",
		'EG-SUZ' => "Egypt: As Suways",
		'EG-SU'  => "Egypt: As Sādis min Uktūbar",
		'EG-SHR' => "Egypt: Ash Sharqīyah",
		'EG-ASN' => "Egypt: Aswān",
		'EG-AST' => "Egypt: Asyūt",
		'EG-BNS' => "Egypt: Banī Suwayf",
		'EG-PTS' => "Egypt: Būr Sa`īd",
		'EG-DT'  => "Egypt: Dumyāt",
		'EG-JS'  => "Egypt: Janūb Sīnā'",
		'EG-KFS' => "Egypt: Kafr ash Shaykh",
		'EG-MT'  => "Egypt: Matrūh",
		'EG-KN'  => "Egypt: Qinā",
		'EG-SIN' => "Egypt: Shamal Sīnā'",
		'EG-SHG' => "Egypt: Sūhāj",
		'EG-HU'  => "Egypt: Ḩulwān",

		'--FR'  => "", '-FR' => "France",
		'FR-01' => "France: Ain",
		'FR-02' => "France: Aisne",
		'FR-03' => "France: Allier",
		'FR-06' => "France: Alpes-Maritimes",
		'FR-04' => "France: Alpes-de-Haute-Provence",
		'FR-A'  => "France: Alsace",
		'FR-B'  => "France: Aquitaine",
		'FR-08' => "France: Ardennes",
		'FR-07' => "France: Ardèche",
		'FR-09' => "France: Ariège",
		'FR-10' => "France: Aube",
		'FR-11' => "France: Aude",
		'FR-C'  => "France: Auvergne",
		'FR-12' => "France: Aveyron",
		'FR-67' => "France: Bas-Rhin",
		'FR-P'  => "France: Basse-Normandie",
		'FR-13' => "France: Bouches-du-Rhône",
		'FR-D'  => "France: Bourgogne",
		'FR-E'  => "France: Bretagne",
		'FR-14' => "France: Calvados",
		'FR-15' => "France: Cantal",
		'FR-F'  => "France: Centre",
		'FR-G'  => "France: Champagne-Ardenne",
		'FR-16' => "France: Charente",
		'FR-17' => "France: Charente-Maritime",
		'FR-18' => "France: Cher",
		'FR-CP' => "France: Clipperton",
		'FR-19' => "France: Corrèze",
		'FR-H'  => "France: Corse",
		'FR-2A' => "France: Corse-du-Sud",
		'FR-23' => "France: Creuse",
		'FR-21' => "France: Côte-d'Or",
		'FR-22' => "France: Côtes-d'Armor",
		'FR-79' => "France: Deux-Sèvres",
		'FR-24' => "France: Dordogne",
		'FR-25' => "France: Doubs",
		'FR-26' => "France: Drôme",
		'FR-91' => "France: Essonne",
		'FR-27' => "France: Eure",
		'FR-28' => "France: Eure-et-Loir",
		'FR-29' => "France: Finistère",
		'FR-I'  => "France: Franche-Comté",
		'FR-30' => "France: Gard",
		'FR-32' => "France: Gers",
		'FR-33' => "France: Gironde",
		'FR-GP' => "France: Guadeloupe",
		'FR-GF' => "France: Guyane",
		'FR-68' => "France: Haut-Rhin",
		'FR-2B' => "France: Haute-Corse",
		'FR-31' => "France: Haute-Garonne",
		'FR-43' => "France: Haute-Loire",
		'FR-52' => "France: Haute-Marne",
		'FR-Q'  => "France: Haute-Normandie",
		'FR-74' => "France: Haute-Savoie",
		'FR-70' => "France: Haute-Saône",
		'FR-87' => "France: Haute-Vienne",
		'FR-05' => "France: Hautes-Alpes",
		'FR-65' => "France: Hautes-Pyrénées",
		'FR-92' => "France: Hauts-de-Seine",
		'FR-34' => "France: Hérault",
		'FR-35' => "France: Ille-et-Vilaine",
		'FR-36' => "France: Indre",
		'FR-37' => "France: Indre-et-Loire",
		'FR-38' => "France: Isère",
		'FR-39' => "France: Jura",
		'FR-40' => "France: Landes",
		'FR-K'  => "France: Languedoc-Roussillon",
		'FR-L'  => "France: Limousin",
		'FR-41' => "France: Loir-et-Cher",
		'FR-42' => "France: Loire",
		'FR-44' => "France: Loire-Atlantique",
		'FR-45' => "France: Loiret",
		'FR-M'  => "France: Lorraine",
		'FR-46' => "France: Lot",
		'FR-47' => "France: Lot-et-Garonne",
		'FR-48' => "France: Lozère",
		'FR-49' => "France: Maine-et-Loire",
		'FR-50' => "France: Manche",
		'FR-51' => "France: Marne",
		'FR-MQ' => "France: Martinique",
		'FR-53' => "France: Mayenne",
		'FR-YT' => "France: Mayotte",
		'FR-54' => "France: Meurthe-et-Moselle",
		'FR-55' => "France: Meuse",
		'FR-N'  => "France: Midi-Pyrénées",
		'FR-56' => "France: Morbihan",
		'FR-57' => "France: Moselle",
		'FR-58' => "France: Nièvre",
		'FR-59' => "France: Nord",
		'FR-O'  => "France: Nord - Pas-de-Calais",
		'FR-NC' => "France: Nouvelle-Calédonie",
		'FR-60' => "France: Oise",
		'FR-61' => "France: Orne",
		'FR-75' => "France: Paris",
		'FR-62' => "France: Pas-de-Calais",
		'FR-R'  => "France: Pays de la Loire",
		'FR-S'  => "France: Picardie",
		'FR-T'  => "France: Poitou-Charentes",
		'FR-PF' => "France: Polynésie française",
		'FR-U'  => "France: Provence-Alpes-Côte d'Azur",
		'FR-63' => "France: Puy-de-Dôme",
		'FR-64' => "France: Pyrénées-Atlantiques",
		'FR-66' => "France: Pyrénées-Orientales",
		'FR-69' => "France: Rhône",
		'FR-V'  => "France: Rhône-Alpes",
		'FR-RE' => "France: Réunion",
		'FR-BL' => "France: Saint-Barthélemy",
		'FR-MF' => "France: Saint-Martin",
		'FR-PM' => "France: Saint-Pierre-et-Miquelon",
		'FR-72' => "France: Sarthe",
		'FR-73' => "France: Savoie",
		'FR-71' => "France: Saône-et-Loire",
		'FR-76' => "France: Seine-Maritime",
		'FR-93' => "France: Seine-Saint-Denis",
		'FR-77' => "France: Seine-et-Marne",
		'FR-80' => "France: Somme",
		'FR-81' => "France: Tarn",
		'FR-82' => "France: Tarn-et-Garonne",
		'FR-TF' => "France: Terres australes françaises",
		'FR-90' => "France: Territoire de Belfort",
		'FR-95' => "France: Val d'Oise",
		'FR-94' => "France: Val-de-Marne",
		'FR-83' => "France: Var",
		'FR-84' => "France: Vaucluse",
		'FR-85' => "France: Vendée",
		'FR-86' => "France: Vienne",
		'FR-88' => "France: Vosges",
		'FR-WF' => "France: Wallis-et-Futuna",
		'FR-89' => "France: Yonne",
		'FR-78' => "France: Yvelines",
		'FR-J'  => "France: Île-de-France",

		'--DE'  => "", '-DE' => "Germany",
		'DE-BW' => "Germany: Baden-Württemberg",
		'DE-BY' => "Germany: Bayern",
		'DE-BE' => "Germany: Berlin",
		'DE-BB' => "Germany: Brandenburg",
		'DE-HB' => "Germany: Bremen",
		'DE-HH' => "Germany: Hamburg",
		'DE-HE' => "Germany: Hessen",
		'DE-MV' => "Germany: Mecklenburg-Vorpommern",
		'DE-NI' => "Germany: Niedersachsen",
		'DE-NW' => "Germany: Nordrhein-Westfalen",
		'DE-RP' => "Germany: Rheinland-Pfalz",
		'DE-SL' => "Germany: Saarland",
		'DE-SN' => "Germany: Sachsen",
		'DE-ST' => "Germany: Sachsen-Anhalt",
		'DE-SH' => "Germany: Schleswig-Holstein",
		'DE-TH' => "Germany: Thüringen",

		'--IN'  => "", '-IN' => "India",
		'IN-AN' => "India: Andaman and Nicobar Islands",
		'IN-AP' => "India: Andhra Pradesh",
		'IN-AR' => "India: Arunāchal Pradesh",
		'IN-AS' => "India: Assam",
		'IN-BR' => "India: Bihār",
		'IN-CH' => "India: Chandīgarh",
		'IN-CT' => "India: Chhattīsgarh",
		'IN-DD' => "India: Damān and Diu",
		'IN-DL' => "India: Delhi",
		'IN-DN' => "India: Dādra and Nagar Haveli",
		'IN-GA' => "India: Goa",
		'IN-GJ' => "India: Gujarāt",
		'IN-HR' => "India: Haryāna",
		'IN-HP' => "India: Himāchal Pradesh",
		'IN-JK' => "India: Jammu and Kashmīr",
		'IN-JH' => "India: Jharkhand",
		'IN-KA' => "India: Karnātaka",
		'IN-KL' => "India: Kerala",
		'IN-LD' => "India: Lakshadweep",
		'IN-MP' => "India: Madhya Pradesh",
		'IN-MH' => "India: Mahārāshtra",
		'IN-MN' => "India: Manipur",
		'IN-ML' => "India: Meghālaya",
		'IN-MZ' => "India: Mizoram",
		'IN-NL' => "India: Nāgāland",
		'IN-OR' => "India: Orissa",
		'IN-PY' => "India: Pondicherry",
		'IN-PB' => "India: Punjab",
		'IN-RJ' => "India: Rājasthān",
		'IN-SK' => "India: Sikkim",
		'IN-TN' => "India: Tamil Nādu",
		'IN-TR' => "India: Tripura",
		'IN-UP' => "India: Uttar Pradesh",
		'IN-UL' => "India: Uttaranchal",
		'IN-WB' => "India: West Bengal",

		'--ID'  => "", '-ID' => "Indonesia",
		'ID-AC' => "Indonesia: Aceh",
		'ID-BA' => "Indonesia: Bali",
		'ID-BB' => "Indonesia: Bangka Belitung",
		'ID-BT' => "Indonesia: Banten",
		'ID-BE' => "Indonesia: Bengkulu",
		'ID-GO' => "Indonesia: Gorontalo",
		'ID-JK' => "Indonesia: Jakarta Raya",
		'ID-JA' => "Indonesia: Jambi",
		'ID-JW' => "Indonesia: Jawa",
		'ID-JB' => "Indonesia: Jawa Barat",
		'ID-JT' => "Indonesia: Jawa Tengah",
		'ID-JI' => "Indonesia: Jawa Timur",
		'ID-KA' => "Indonesia: Kalimantan",
		'ID-KB' => "Indonesia: Kalimantan Barat",
		'ID-KS' => "Indonesia: Kalimantan Selatan",
		'ID-KT' => "Indonesia: Kalimantan Tengah",
		'ID-KI' => "Indonesia: Kalimantan Timur",
		'ID-KR' => "Indonesia: Kepulauan Riau",
		'ID-LA' => "Indonesia: Lampung",
		'ID-MA' => "Indonesia: Maluku",
		'ID-MU' => "Indonesia: Maluku Utara",
		'ID-NU' => "Indonesia: Nusa Tenggara",
		'ID-NB' => "Indonesia: Nusa Tenggara Barat",
		'ID-NT' => "Indonesia: Nusa Tenggara Timur",
		'ID-PA' => "Indonesia: Papua",
		'ID-PB' => "Indonesia: Papua Barat",
		'ID-RI' => "Indonesia: Riau",
		'ID-SL' => "Indonesia: Sulawesi",
		'ID-SR' => "Indonesia: Sulawesi Barat",
		'ID-SN' => "Indonesia: Sulawesi Selatan",
		'ID-ST' => "Indonesia: Sulawesi Tengah",
		'ID-SG' => "Indonesia: Sulawesi Tenggara",
		'ID-SA' => "Indonesia: Sulawesi Utara",
		'ID-SM' => "Indonesia: Sumatera",
		'ID-SU' => "Indonesia: Sumatera Utara",
		'ID-SB' => "Indonesia: Sumatra Barat",
		'ID-SS' => "Indonesia: Sumatra Selatan",
		'ID-YO' => "Indonesia: Yogyakarta",

		'--IT'  => "", '-IT' => "Italy",
		'IT-65' => "Italy: Abruzzo",
		'IT-AG' => "Italy: Agrigento",
		'IT-AL' => "Italy: Alessandria",
		'IT-AN' => "Italy: Ancona",
		'IT-AO' => "Italy: Aosta",
		'IT-AR' => "Italy: Arezzo",
		'IT-AP' => "Italy: Ascoli Piceno",
		'IT-AT' => "Italy: Asti",
		'IT-AV' => "Italy: Avellino",
		'IT-BA' => "Italy: Bari",
		'IT-BT' => "Italy: Barletta-Andria-Trani",
		'IT-77' => "Italy: Basilicata",
		'IT-BL' => "Italy: Belluno",
		'IT-BN' => "Italy: Benevento",
		'IT-BG' => "Italy: Bergamo",
		'IT-BI' => "Italy: Biella",
		'IT-BO' => "Italy: Bologna",
		'IT-BZ' => "Italy: Bolzano",
		'IT-BS' => "Italy: Brescia",
		'IT-BR' => "Italy: Brindisi",
		'IT-CA' => "Italy: Cagliari",
		'IT-78' => "Italy: Calabria",
		'IT-CL' => "Italy: Caltanissetta",
		'IT-72' => "Italy: Campania",
		'IT-CB' => "Italy: Campobasso",
		'IT-CI' => "Italy: Carbonia-Iglesias",
		'IT-CE' => "Italy: Caserta",
		'IT-CT' => "Italy: Catania",
		'IT-CZ' => "Italy: Catanzaro",
		'IT-CH' => "Italy: Chieti",
		'IT-CO' => "Italy: Como",
		'IT-CS' => "Italy: Cosenza",
		'IT-CR' => "Italy: Cremona",
		'IT-KR' => "Italy: Crotone",
		'IT-CN' => "Italy: Cuneo",
		'IT-45' => "Italy: Emilia-Romagna",
		'IT-EN' => "Italy: Enna",
		'IT-FM' => "Italy: Fermo",
		'IT-FE' => "Italy: Ferrara",
		'IT-FI' => "Italy: Firenze",
		'IT-FG' => "Italy: Foggia",
		'IT-FC' => "Italy: Forlì-Cesena",
		'IT-36' => "Italy: Friuli-Venezia Giulia",
		'IT-FR' => "Italy: Frosinone",
		'IT-GE' => "Italy: Genova",
		'IT-GO' => "Italy: Gorizia",
		'IT-GR' => "Italy: Grosseto",
		'IT-IM' => "Italy: Imperia",
		'IT-IS' => "Italy: Isernia",
		'IT-AQ' => "Italy: L'Aquila",
		'IT-SP' => "Italy: La Spezia",
		'IT-LT' => "Italy: Latina",
		'IT-62' => "Italy: Lazio",
		'IT-LE' => "Italy: Lecce",
		'IT-LC' => "Italy: Lecco",
		'IT-42' => "Italy: Liguria",
		'IT-LI' => "Italy: Livorno",
		'IT-LO' => "Italy: Lodi",
		'IT-25' => "Italy: Lombardia",
		'IT-LU' => "Italy: Lucca",
		'IT-MC' => "Italy: Macerata",
		'IT-MN' => "Italy: Mantova",
		'IT-57' => "Italy: Marche",
		'IT-MS' => "Italy: Massa-Carrara",
		'IT-MT' => "Italy: Matera",
		'IT-VS' => "Italy: Medio Campidano",
		'IT-ME' => "Italy: Messina",
		'IT-MI' => "Italy: Milano",
		'IT-MO' => "Italy: Modena",
		'IT-67' => "Italy: Molise",
		'IT-MB' => "Italy: Monza e Brianza",
		'IT-NA' => "Italy: Napoli",
		'IT-NO' => "Italy: Novara",
		'IT-NU' => "Italy: Nuoro",
		'IT-OG' => "Italy: Ogliastra",
		'IT-OT' => "Italy: Olbia-Tempio",
		'IT-OR' => "Italy: Oristano",
		'IT-PD' => "Italy: Padova",
		'IT-PA' => "Italy: Palermo",
		'IT-PR' => "Italy: Parma",
		'IT-PV' => "Italy: Pavia",
		'IT-PG' => "Italy: Perugia",
		'IT-PU' => "Italy: Pesaro e Urbino",
		'IT-PE' => "Italy: Pescara",
		'IT-PC' => "Italy: Piacenza",
		'IT-21' => "Italy: Piemonte",
		'IT-PI' => "Italy: Pisa",
		'IT-PT' => "Italy: Pistoia",
		'IT-PN' => "Italy: Pordenone",
		'IT-PZ' => "Italy: Potenza",
		'IT-PO' => "Italy: Prato",
		'IT-75' => "Italy: Puglia",
		'IT-RG' => "Italy: Ragusa",
		'IT-RA' => "Italy: Ravenna",
		'IT-RC' => "Italy: Reggio Calabria",
		'IT-RE' => "Italy: Reggio Emilia",
		'IT-RI' => "Italy: Rieti",
		'IT-RN' => "Italy: Rimini",
		'IT-RM' => "Italy: Roma",
		'IT-RO' => "Italy: Rovigo",
		'IT-SA' => "Italy: Salerno",
		'IT-88' => "Italy: Sardegna",
		'IT-SS' => "Italy: Sassari",
		'IT-SV' => "Italy: Savona",
		'IT-82' => "Italy: Sicilia",
		'IT-SI' => "Italy: Siena",
		'IT-SR' => "Italy: Siracusa",
		'IT-SO' => "Italy: Sondrio",
		'IT-TA' => "Italy: Taranto",
		'IT-TE' => "Italy: Teramo",
		'IT-TR' => "Italy: Terni",
		'IT-TO' => "Italy: Torino",
		'IT-52' => "Italy: Toscana",
		'IT-TP' => "Italy: Trapani",
		'IT-32' => "Italy: Trentino-Alto Adige",
		'IT-TN' => "Italy: Trento",
		'IT-TV' => "Italy: Treviso",
		'IT-TS' => "Italy: Trieste",
		'IT-UD' => "Italy: Udine",
		'IT-55' => "Italy: Umbria",
		'IT-23' => "Italy: Valle d'Aosta",
		'IT-VA' => "Italy: Varese",
		'IT-34' => "Italy: Veneto",
		'IT-VE' => "Italy: Venezia",
		'IT-VB' => "Italy: Verbano-Cusio-Ossola",
		'IT-VC' => "Italy: Vercelli",
		'IT-VR' => "Italy: Verona",
		'IT-VV' => "Italy: Vibo Valentia",
		'IT-VI' => "Italy: Vicenza",
		'IT-VT' => "Italy: Viterbo",

		'--JP'  => "", '-JP' => "Japan",
		'JP-23' => "Japan: Aichi",
		'JP-05' => "Japan: Akita",
		'JP-02' => "Japan: Aomori",
		'JP-12' => "Japan: Chiba",
		'JP-38' => "Japan: Ehime",
		'JP-18' => "Japan: Fukui",
		'JP-40' => "Japan: Fukuoka",
		'JP-07' => "Japan: Fukushima",
		'JP-21' => "Japan: Gifu",
		'JP-10' => "Japan: Gunma",
		'JP-34' => "Japan: Hiroshima",
		'JP-01' => "Japan: Hokkaido",
		'JP-28' => "Japan: Hyogo",
		'JP-08' => "Japan: Ibaraki",
		'JP-17' => "Japan: Ishikawa",
		'JP-03' => "Japan: Iwate",
		'JP-37' => "Japan: Kagawa",
		'JP-46' => "Japan: Kagoshima",
		'JP-14' => "Japan: Kanagawa",
		'JP-39' => "Japan: Kochi",
		'JP-43' => "Japan: Kumamoto",
		'JP-26' => "Japan: Kyoto",
		'JP-24' => "Japan: Mie",
		'JP-04' => "Japan: Miyagi",
		'JP-45' => "Japan: Miyazaki",
		'JP-20' => "Japan: Nagano",
		'JP-42' => "Japan: Nagasaki",
		'JP-29' => "Japan: Nara",
		'JP-15' => "Japan: Niigata",
		'JP-44' => "Japan: Oita",
		'JP-33' => "Japan: Okayama",
		'JP-47' => "Japan: Okinawa",
		'JP-27' => "Japan: Osaka",
		'JP-41' => "Japan: Saga",
		'JP-11' => "Japan: Saitama",
		'JP-25' => "Japan: Shiga",
		'JP-32' => "Japan: Shimane",
		'JP-22' => "Japan: Shizuoka",
		'JP-09' => "Japan: Tochigi",
		'JP-36' => "Japan: Tokushima",
		'JP-13' => "Japan: Tokyo",
		'JP-31' => "Japan: Tottori",
		'JP-16' => "Japan: Toyama",
		'JP-30' => "Japan: Wakayama",
		'JP-06' => "Japan: Yamagata",
		'JP-35' => "Japan: Yamaguchi",
		'JP-19' => "Japan: Yamanashi",

		'--MX'   => "", '-MX' => "Mexico",
		'MX-AGU' => "Mexico: Aguascalientes",
		'MX-BCN' => "Mexico: Baja California",
		'MX-BCS' => "Mexico: Baja California Sur",
		'MX-CAM' => "Mexico: Campeche",
		'MX-CHP' => "Mexico: Chiapas",
		'MX-CHH' => "Mexico: Chihuahua",
		'MX-COA' => "Mexico: Coahuila",
		'MX-COL' => "Mexico: Colima",
		'MX-DIF' => "Mexico: Distrito Federal",
		'MX-DUR' => "Mexico: Durango",
		'MX-GUA' => "Mexico: Guanajuato",
		'MX-GRO' => "Mexico: Guerrero",
		'MX-HID' => "Mexico: Hidalgo",
		'MX-JAL' => "Mexico: Jalisco",
		'MX-MIC' => "Mexico: Michoacán",
		'MX-MOR' => "Mexico: Morelos",
		'MX-MEX' => "Mexico: México",
		'MX-NAY' => "Mexico: Nayarit",
		'MX-NLE' => "Mexico: Nuevo León",
		'MX-OAX' => "Mexico: Oaxaca",
		'MX-PUE' => "Mexico: Puebla",
		'MX-QUE' => "Mexico: Querétaro",
		'MX-ROO' => "Mexico: Quintana Roo",
		'MX-SLP' => "Mexico: San Luis Potosí",
		'MX-SIN' => "Mexico: Sinaloa",
		'MX-SON' => "Mexico: Sonora",
		'MX-TAB' => "Mexico: Tabasco",
		'MX-TAM' => "Mexico: Tamaulipas",
		'MX-TLA' => "Mexico: Tlaxcala",
		'MX-VER' => "Mexico: Veracruz",
		'MX-YUC' => "Mexico: Yucatán",
		'MX-ZAC' => "Mexico: Zacatecas",

		'--MA'   => "", '-MA' => "Morocco",
		'MA-AGD' => "Morocco: Agadir-Ida-Outanane",
		'MA-HAO' => "Morocco: Al Haouz",
		'MA-HOC' => "Morocco: Al Hoceïma",
		'MA-AOU' => "Morocco: Aousserd",
		'MA-ASZ' => "Morocco: Assa-Zag",
		'MA-AZI' => "Morocco: Azilal",
		'MA-BES' => "Morocco: Ben Slimane",
		'MA-BEM' => "Morocco: Beni Mellal",
		'MA-BER' => "Morocco: Berkane",
		'MA-BOD' => "Morocco: Boujdour (EH)",
		'MA-BOM' => "Morocco: Boulemane",
		'MA-CAS' => "Morocco: Casablanca [Dar el Beïda]",
		'MA-09'  => "Morocco: Chaouia-Ouardigha",
		'MA-CHE' => "Morocco: Chefchaouen",
		'MA-CHI' => "Morocco: Chichaoua",
		'MA-CHT' => "Morocco: Chtouka-Ait Baha",
		'MA-10'  => "Morocco: Doukhala-Abda",
		'MA-HAJ' => "Morocco: El Hajeb",
		'MA-JDI' => "Morocco: El Jadida",
		'MA-ERR' => "Morocco: Errachidia",
		'MA-ESM' => "Morocco: Es Smara (EH)",
		'MA-ESI' => "Morocco: Essaouira",
		'MA-FAH' => "Morocco: Fahs-Beni Makada",
		'MA-FIG' => "Morocco: Figuig",
		'MA-05'  => "Morocco: Fès-Boulemane",
		'MA-FES' => "Morocco: Fès-Dar-Dbibegh",
		'MA-02'  => "Morocco: Gharb-Chrarda-Beni Hssen",
		'MA-08'  => "Morocco: Grand Casablanca",
		'MA-GUE' => "Morocco: Guelmim",
		'MA-14'  => "Morocco: Guelmim-Es Smara",
		'MA-IFR' => "Morocco: Ifrane",
		'MA-INE' => "Morocco: Inezgane-Ait Melloul",
		'MA-JRA' => "Morocco: Jrada",
		'MA-KES' => "Morocco: Kelaat es Sraghna",
		'MA-KHE' => "Morocco: Khemisaet",
		'MA-KHN' => "Morocco: Khenifra",
		'MA-KHO' => "Morocco: Khouribga",
		'MA-KEN' => "Morocco: Kénitra",
		'MA-04'  => "Morocco: L'Oriental",
		'MA-LAR' => "Morocco: Larache",
		'MA-LAA' => "Morocco: Laâyoune (EH)",
		'MA-15'  => "Morocco: Laâyoune-Boujdour-Sakia el Hamra",
		'MA-MMD' => "Morocco: Marrakech-Medina",
		'MA-MMN' => "Morocco: Marrakech-Menara",
		'MA-11'  => "Morocco: Marrakech-Tensift-Al Haouz",
		'MA-MEK' => "Morocco: Meknès",
		'MA-06'  => "Morocco: Meknès-Tafilalet",
		'MA-MOH' => "Morocco: Mohammadia",
		'MA-MOU' => "Morocco: Moulay Yacoub",
		'MA-MED' => "Morocco: Médiouna",
		'MA-NAD' => "Morocco: Nador",
		'MA-NOU' => "Morocco: Nouaceur",
		'MA-OUA' => "Morocco: Ouarzazate",
		'MA-OUD' => "Morocco: Oued ed Dahab (EH)",
		'MA-16'  => "Morocco: Oued ed Dahab-Lagouira",
		'MA-OUJ' => "Morocco: Oujda-Angad",
		'MA-RAB' => "Morocco: Rabat",
		'MA-07'  => "Morocco: Rabat-Salé-Zemmour-Zaer",
		'MA-SAF' => "Morocco: Safi",
		'MA-SAL' => "Morocco: Salé",
		'MA-SEF' => "Morocco: Sefrou",
		'MA-SET' => "Morocco: Settat",
		'MA-SYB' => "Morocco: Sidi Youssef Ben Ali",
		'MA-SIK' => "Morocco: Sidl Kacem",
		'MA-SKH' => "Morocco: Skhirate-Témara",
		'MA-13'  => "Morocco: Sous-Massa-Draa",
		'MA-12'  => "Morocco: Tadla-Azilal",
		'MA-TNT' => "Morocco: Tan-Tan",
		'MA-TNG' => "Morocco: Tanger-Assilah",
		'MA-01'  => "Morocco: Tanger-Tétouan",
		'MA-TAO' => "Morocco: Taounate",
		'MA-TAI' => "Morocco: Taourirt",
		'MA-TAR' => "Morocco: Taroudant",
		'MA-TAT' => "Morocco: Tata",
		'MA-TAZ' => "Morocco: Taza",
		'MA-03'  => "Morocco: Taza-Al Hoceima-Taounate",
		'MA-TIZ' => "Morocco: Tiznit",
		'MA-TET' => "Morocco: Tétouan",
		'MA-ZAG' => "Morocco: Zagora",

		'--NL'  => "", '-NL' => "Netherlands",
		'NL-DR' => "Netherlands: Drenthe",
		'NL-FL' => "Netherlands: Flevoland",
		'NL-FR' => "Netherlands: Friesland",
		'NL-GE' => "Netherlands: Gelderland",
		'NL-GR' => "Netherlands: Groningen",
		'NL-LI' => "Netherlands: Limburg",
		'NL-NB' => "Netherlands: Noord-Brabant",
		'NL-NH' => "Netherlands: Noord-Holland",
		'NL-OV' => "Netherlands: Overijssel",
		'NL-UT' => "Netherlands: Utrecht",
		'NL-ZE' => "Netherlands: Zeeland",
		'NL-ZH' => "Netherlands: Zuid-Holland",

		'--NG'  => "", '-NG' => "Nigeria",
		'NG-AB' => "Nigeria: Abia",
		'NG-FC' => "Nigeria: Abuja Capital Territory",
		'NG-AD' => "Nigeria: Adamawa",
		'NG-AK' => "Nigeria: Akwa Ibom",
		'NG-AN' => "Nigeria: Anambra",
		'NG-BA' => "Nigeria: Bauchi",
		'NG-BY' => "Nigeria: Bayelsa",
		'NG-BE' => "Nigeria: Benue",
		'NG-BO' => "Nigeria: Borno",
		'NG-CR' => "Nigeria: Cross River",
		'NG-DE' => "Nigeria: Delta",
		'NG-EB' => "Nigeria: Ebonyi",
		'NG-ED' => "Nigeria: Edo",
		'NG-EK' => "Nigeria: Ekiti",
		'NG-EN' => "Nigeria: Enugu",
		'NG-GO' => "Nigeria: Gombe",
		'NG-IM' => "Nigeria: Imo",
		'NG-JI' => "Nigeria: Jigawa",
		'NG-KD' => "Nigeria: Kaduna",
		'NG-KN' => "Nigeria: Kano",
		'NG-KT' => "Nigeria: Katsina",
		'NG-KE' => "Nigeria: Kebbi",
		'NG-KO' => "Nigeria: Kogi",
		'NG-KW' => "Nigeria: Kwara",
		'NG-LA' => "Nigeria: Lagos",
		'NG-NA' => "Nigeria: Nassarawa",
		'NG-NI' => "Nigeria: Niger, Níger",
		'NG-OG' => "Nigeria: Ogun",
		'NG-ON' => "Nigeria: Ondo",
		'NG-OS' => "Nigeria: Osun",
		'NG-OY' => "Nigeria: Oyo",
		'NG-PL' => "Nigeria: Plateau",
		'NG-RI' => "Nigeria: Rivers",
		'NG-SO' => "Nigeria: Sokoto",
		'NG-TA' => "Nigeria: Taraba",
		'NG-YO' => "Nigeria: Yobe",
		'NG-ZA' => "Nigeria: Zamfara",

		'--NO'  => "", '-NO' => "Norway",
		'NO-02' => "Norway: Akershus",
		'NO-09' => "Norway: Aust-Agder",
		'NO-06' => "Norway: Buskerud",
		'NO-20' => "Norway: Finnmark",
		'NO-04' => "Norway: Hedmark",
		'NO-12' => "Norway: Hordaland",
		'NO-22' => "Norway: Jan Mayen",
		'NO-15' => "Norway: Møre og Romsdal",
		'NO-17' => "Norway: Nord-Trøndelag",
		'NO-18' => "Norway: Nordland",
		'NO-05' => "Norway: Oppland",
		'NO-03' => "Norway: Oslo",
		'NO-11' => "Norway: Rogaland",
		'NO-14' => "Norway: Sogn og Fjordane",
		'NO-21' => "Norway: Svalbard",
		'NO-16' => "Norway: Sør-Trøndelag",
		'NO-08' => "Norway: Telemark",
		'NO-19' => "Norway: Troms",
		'NO-10' => "Norway: Vest-Agder",
		'NO-07' => "Norway: Vestfold",
		'NO-01' => "Norway: Østfold",

		'--PH'   => "", '-PH' => "Philippines",
		'PH-ABR' => "Philippines: Abra",
		'PH-AGN' => "Philippines: Agusan del Norte",
		'PH-AGS' => "Philippines: Agusan del Sur",
		'PH-AKL' => "Philippines: Aklan",
		'PH-ALB' => "Philippines: Albay",
		'PH-ANT' => "Philippines: Antique",
		'PH-APA' => "Philippines: Apayao",
		'PH-AUR' => "Philippines: Aurora",
		'PH-14'  => "Philippines: Autonomous Region in Muslim Mindanao (ARMM)",
		'PH-BAS' => "Philippines: Basilan",
		'PH-BTN' => "Philippines: Batanes",
		'PH-BTG' => "Philippines: Batangas",
		'PH-BAN' => "Philippines: Batasn",
		'PH-BEN' => "Philippines: Benguet",
		'PH-05'  => "Philippines: Bicol (Region V)",
		'PH-BIL' => "Philippines: Biliran",
		'PH-BOH' => "Philippines: Bohol",
		'PH-BUK' => "Philippines: Bukidnon",
		'PH-BUL' => "Philippines: Bulacan",
		'PH-40'  => "Philippines: CALABARZON (Region IV-A)",
		'PH-CAG' => "Philippines: Cagayan",
		'PH-02'  => "Philippines: Cagayan Valley (Region II)",
		'PH-CAN' => "Philippines: Camarines Norte",
		'PH-CAS' => "Philippines: Camarines Sur",
		'PH-CAM' => "Philippines: Camiguin",
		'PH-CAP' => "Philippines: Capiz",
		'PH-13'  => "Philippines: Caraga (Region XIII)",
		'PH-CAT' => "Philippines: Catanduanes",
		'PH-CAV' => "Philippines: Cavite",
		'PH-CEB' => "Philippines: Cebu",
		'PH-03'  => "Philippines: Central Luzon (Region III)",
		'PH-07'  => "Philippines: Central Visayas (Region VII)",
		'PH-COM' => "Philippines: Compostela Valley",
		'PH-15'  => "Philippines: Cordillera Administrative Region (CAR)",
		'PH-11'  => "Philippines: Davao (Region XI)",
		'PH-DAO' => "Philippines: Davao Oriental",
		'PH-DAV' => "Philippines: Davao del Norte",
		'PH-DAS' => "Philippines: Davao del Sur",
		'PH-DIN' => "Philippines: Dinagat Islands",
		'PH-EAS' => "Philippines: Eastern Samar",
		'PH-08'  => "Philippines: Eastern Visayas (Region VIII)",
		'PH-GUI' => "Philippines: Guimaras",
		'PH-IFU' => "Philippines: Ifugao",
		'PH-01'  => "Philippines: Ilocos (Region I)",
		'PH-ILN' => "Philippines: Ilocos Norte",
		'PH-ILS' => "Philippines: Ilocos Sur",
		'PH-ILI' => "Philippines: Iloilo",
		'PH-ISA' => "Philippines: Isabela",
		'PH-KAL' => "Philippines: Kalinga-Apayso",
		'PH-LUN' => "Philippines: La Union",
		'PH-LAG' => "Philippines: Laguna",
		'PH-LAN' => "Philippines: Lanao del Norte",
		'PH-LAS' => "Philippines: Lanao del Sur",
		'PH-LEY' => "Philippines: Leyte",
		'PH-41'  => "Philippines: MIMAROPA (Region IV-B)",
		'PH-MAG' => "Philippines: Maguindanao",
		'PH-MAD' => "Philippines: Marinduque",
		'PH-MAS' => "Philippines: Masbate",
		'PH-MDC' => "Philippines: Mindoro Occidental",
		'PH-MDR' => "Philippines: Mindoro Oriental",
		'PH-MSC' => "Philippines: Misamis Occidental",
		'PH-MSR' => "Philippines: Misamis Oriental",
		'PH-MOU' => "Philippines: Mountain Province",
		'PH-00'  => "Philippines: National Capital Region",
		'PH-NEC' => "Philippines: Negroe Occidental",
		'PH-NER' => "Philippines: Negros Oriental",
		'PH-NCO' => "Philippines: North Cotabato",
		'PH-10'  => "Philippines: Northern Mindanao (Region X)",
		'PH-NSA' => "Philippines: Northern Samar",
		'PH-NUE' => "Philippines: Nueva Ecija",
		'PH-NUV' => "Philippines: Nueva Vizcaya",
		'PH-PLW' => "Philippines: Palawan",
		'PH-PAM' => "Philippines: Pampanga",
		'PH-PAN' => "Philippines: Pangasinan",
		'PH-QUE' => "Philippines: Quezon",
		'PH-QUI' => "Philippines: Quirino",
		'PH-RIZ' => "Philippines: Rizal",
		'PH-ROM' => "Philippines: Romblon",
		'PH-SAR' => "Philippines: Sarangani",
		'PH-SIG' => "Philippines: Siquijor",
		'PH-12'  => "Philippines: Soccsksargen (Region XII)",
		'PH-SOR' => "Philippines: Sorsogon",
		'PH-SCO' => "Philippines: South Cotabato",
		'PH-SLE' => "Philippines: Southern Leyte",
		'PH-SUK' => "Philippines: Sultan Kudarat",
		'PH-SLU' => "Philippines: Sulu",
		'PH-SUN' => "Philippines: Surigao del Norte",
		'PH-SUR' => "Philippines: Surigao del Sur",
		'PH-TAR' => "Philippines: Tarlac",
		'PH-TAW' => "Philippines: Tawi-Tawi",
		'PH-WSA' => "Philippines: Western Samar",
		'PH-06'  => "Philippines: Western Visayas (Region VI)",
		'PH-ZMB' => "Philippines: Zambales",
		'PH-09'  => "Philippines: Zamboanga Peninsula (Region IX)",
		'PH-ZSI' => "Philippines: Zamboanga Sibugay",
		'PH-ZAN' => "Philippines: Zamboanga del Norte",
		'PH-ZAS' => "Philippines: Zamboanga del Sur",

		'--PT'  => "", '-PT' => "Portugal",
		'PT-01' => "Portugal: Aveiro",
		'PT-02' => "Portugal: Beja",
		'PT-03' => "Portugal: Braga",
		'PT-04' => "Portugal: Bragança",
		'PT-05' => "Portugal: Castelo Branco",
		'PT-06' => "Portugal: Coimbra",
		'PT-08' => "Portugal: Faro",
		'PT-09' => "Portugal: Guarda",
		'PT-10' => "Portugal: Leiria",
		'PT-11' => "Portugal: Lisboa",
		'PT-12' => "Portugal: Portalegre",
		'PT-13' => "Portugal: Porto",
		'PT-30' => "Portugal: Região Autónoma da Madeira",
		'PT-20' => "Portugal: Região Autónoma dos Açores",
		'PT-14' => "Portugal: Santarém",
		'PT-15' => "Portugal: Setúbal",
		'PT-16' => "Portugal: Viana do Castelo",
		'PT-17' => "Portugal: Vila Real",
		'PT-18' => "Portugal: Viseu",
		'PT-07' => "Portugal: Évora",

		'--RU'   => "", '-RU' => "Russian Federation",
		'RU-AD'  => "Russian Federation: Adygeya, Respublika",
		'RU-AL'  => "Russian Federation: Altay, Respublika",
		'RU-ALT' => "Russian Federation: Altayskiy kray",
		'RU-AMU' => "Russian Federation: Amurskaya oblast'",
		'RU-ARK' => "Russian Federation: Arkhangel'skaya oblast'",
		'RU-AST' => "Russian Federation: Astrakhanskaya oblast'",
		'RU-BA'  => "Russian Federation: Bashkortostan, Respublika",
		'RU-BEL' => "Russian Federation: Belgorodskaya oblast'",
		'RU-BRY' => "Russian Federation: Bryanskaya oblast'",
		'RU-BU'  => "Russian Federation: Buryatiya, Respublika",
		'RU-CE'  => "Russian Federation: Chechenskaya Respublika",
		'RU-CHE' => "Russian Federation: Chelyabinskaya oblast'",
		'RU-CHU' => "Russian Federation: Chukotskiy avtonomnyy okrug",
		'RU-CU'  => "Russian Federation: Chuvashskaya Respublika",
		'RU-DA'  => "Russian Federation: Dagestan, Respublika",
		'RU-IRK' => "Russian Federation: Irkutiskaya oblast'",
		'RU-IVA' => "Russian Federation: Ivanovskaya oblast'",
		'RU-KB'  => "Russian Federation: Kabardino-Balkarskaya Respublika",
		'RU-KGD' => "Russian Federation: Kaliningradskaya oblast'",
		'RU-KL'  => "Russian Federation: Kalmykiya, Respublika",
		'RU-KLU' => "Russian Federation: Kaluzhskaya oblast'",
		'RU-KAM' => "Russian Federation: Kamchatskiy kray",
		'RU-KC'  => "Russian Federation: Karachayevo-Cherkesskaya Respublika",
		'RU-KR'  => "Russian Federation: Kareliya, Respublika",
		'RU-KEM' => "Russian Federation: Kemerovskaya oblast'",
		'RU-KHA' => "Russian Federation: Khabarovskiy kray",
		'RU-KK'  => "Russian Federation: Khakasiya, Respublika",
		'RU-KHM' => "Russian Federation: Khanty-Mansiysky avtonomnyy okrug-Yugra",
		'RU-KIR' => "Russian Federation: Kirovskaya oblast'",
		'RU-KO'  => "Russian Federation: Komi, Respublika",
		'RU-KOS' => "Russian Federation: Kostromskaya oblast'",
		'RU-KDA' => "Russian Federation: Krasnodarskiy kray",
		'RU-KYA' => "Russian Federation: Krasnoyarskiy kray",
		'RU-KGN' => "Russian Federation: Kurganskaya oblast'",
		'RU-KRS' => "Russian Federation: Kurskaya oblast'",
		'RU-LEN' => "Russian Federation: Leningradskaya oblast'",
		'RU-LIP' => "Russian Federation: Lipetskaya oblast'",
		'RU-MAG' => "Russian Federation: Magadanskaya oblast'",
		'RU-ME'  => "Russian Federation: Mariy El, Respublika",
		'RU-MO'  => "Russian Federation: Mordoviya, Respublika",
		'RU-MOS' => "Russian Federation: Moskovskaya oblast'",
		'RU-MOW' => "Russian Federation: Moskva",
		'RU-MUR' => "Russian Federation: Murmanskaya oblast'",
		'RU-NEN' => "Russian Federation: Nenetskiy avtonomnyy okrug",
		'RU-NIZ' => "Russian Federation: Nizhegorodskaya oblast'",
		'RU-NGR' => "Russian Federation: Novgorodskaya oblast'",
		'RU-NVS' => "Russian Federation: Novosibirskaya oblast'",
		'RU-OMS' => "Russian Federation: Omskaya oblast'",
		'RU-ORE' => "Russian Federation: Orenburgskaya oblast'",
		'RU-ORL' => "Russian Federation: Orlovskaya oblast'",
		'RU-PNZ' => "Russian Federation: Penzenskaya oblast'",
		'RU-PER' => "Russian Federation: Permskiy kray",
		'RU-PRI' => "Russian Federation: Primorskiy kray",
		'RU-PSK' => "Russian Federation: Pskovskaya oblast'",
		'RU-IN'  => "Russian Federation: Respublika Ingushetiya",
		'RU-ROS' => "Russian Federation: Rostovskaya oblast'",
		'RU-RYA' => "Russian Federation: Ryazanskaya oblast'",
		'RU-SA'  => "Russian Federation: Sakha, Respublika [Yakutiya]",
		'RU-SAK' => "Russian Federation: Sakhalinskaya oblast'",
		'RU-SAM' => "Russian Federation: Samaraskaya oblast'",
		'RU-SPE' => "Russian Federation: Sankt-Peterburg",
		'RU-SAR' => "Russian Federation: Saratovskaya oblast'",
		'RU-SE'  => "Russian Federation: Severnaya Osetiya-Alaniya, Respublika",
		'RU-SMO' => "Russian Federation: Smolenskaya oblast'",
		'RU-STA' => "Russian Federation: Stavropol'skiy kray",
		'RU-SVE' => "Russian Federation: Sverdlovskaya oblast'",
		'RU-TAM' => "Russian Federation: Tambovskaya oblast'",
		'RU-TA'  => "Russian Federation: Tatarstan, Respublika",
		'RU-TOM' => "Russian Federation: Tomskaya oblast'",
		'RU-TUL' => "Russian Federation: Tul'skaya oblast'",
		'RU-TVE' => "Russian Federation: Tverskaya oblast'",
		'RU-TYU' => "Russian Federation: Tyumenskaya oblast'",
		'RU-TY'  => "Russian Federation: Tyva, Respublika [Tuva]",
		'RU-UD'  => "Russian Federation: Udmurtskaya Respublika",
		'RU-ULY' => "Russian Federation: Ul'yanovskaya oblast'",
		'RU-VLA' => "Russian Federation: Vladimirskaya oblast'",
		'RU-VGG' => "Russian Federation: Volgogradskaya oblast'",
		'RU-VLG' => "Russian Federation: Vologodskaya oblast'",
		'RU-VOR' => "Russian Federation: Voronezhskaya oblast'",
		'RU-YAN' => "Russian Federation: Yamalo-Nenetskiy avtonomnyy okrug",
		'RU-YAR' => "Russian Federation: Yaroslavskaya oblast'",
		'RU-YEV' => "Russian Federation: Yevreyskaya avtonomnaya oblast'",
		'RU-ZAB' => "Russian Federation: Zabajkal'skij kraj",

		'--ES'  => "", '-ES' => "Spain",
		'ES-C'  => "Spain: A Coruña",
		'ES-AB' => "Spain: Albacete",
		'ES-A'  => "Spain: Alicante",
		'ES-AL' => "Spain: Almería",
		'ES-AN' => "Spain: Andalucía",
		'ES-AR' => "Spain: Aragón",
		'ES-O'  => "Spain: Asturias",
		'ES-AS' => "Spain: Asturias, Principado de",
		'ES-BA' => "Spain: Badajoz",
		'ES-PM' => "Spain: Balears",
		'ES-B'  => "Spain: Barcelona",
		'ES-BU' => "Spain: Burgos",
		'ES-CN' => "Spain: Canarias",
		'ES-S'  => "Spain: Cantabria",
		'ES-CS' => "Spain: Castellón",
		'ES-CL' => "Spain: Castilla y León",
		'ES-CM' => "Spain: Castilla-La Mancha",
		'ES-CT' => "Spain: Catalunya",
		'ES-CE' => "Spain: Ceuta",
		'ES-CR' => "Spain: Ciudad Real",
		'ES-CU' => "Spain: Cuenca",
		'ES-CC' => "Spain: Cáceres",
		'ES-CA' => "Spain: Cádiz",
		'ES-CO' => "Spain: Córdoba",
		'ES-EX' => "Spain: Extremadura",
		'ES-GA' => "Spain: Galicia",
		'ES-GI' => "Spain: Girona",
		'ES-GR' => "Spain: Granada",
		'ES-GU' => "Spain: Guadalajara",
		'ES-SS' => "Spain: Guipúzcoa / Gipuzkoa",
		'ES-H'  => "Spain: Huelva",
		'ES-HU' => "Spain: Huesca",
		'ES-IB' => "Spain: Illes Balears",
		'ES-J'  => "Spain: Jaén",
		'ES-LO' => "Spain: La Rioja",
		'ES-GC' => "Spain: Las Palmas",
		'ES-LE' => "Spain: León",
		'ES-L'  => "Spain: Lleida",
		'ES-LU' => "Spain: Lugo",
		'ES-M'  => "Spain: Madrid",
		'ES-MD' => "Spain: Madrid, Comunidad de",
		'ES-ML' => "Spain: Melilla",
		'ES-MU' => "Spain: Murcia",
		'ES-MC' => "Spain: Murcia, Región de",
		'ES-MA' => "Spain: Málaga",
		'ES-NA' => "Spain: Navarra / Nafarroa",
		'ES-NC' => "Spain: Navarra, Comunidad Foral de / Nafarroako Foru Komunitatea",
		'ES-OR' => "Spain: Ourense",
		'ES-P'  => "Spain: Palencia",
		'ES-PV' => "Spain: País Vasco / Euskal Herria",
		'ES-PO' => "Spain: Pontevedra",
		'ES-SA' => "Spain: Salamanca",
		'ES-TF' => "Spain: Santa Cruz de Tenerife",
		'ES-SG' => "Spain: Segovia",
		'ES-SE' => "Spain: Sevilla",
		'ES-SO' => "Spain: Soria",
		'ES-T'  => "Spain: Tarragona",
		'ES-TE' => "Spain: Teruel",
		'ES-TO' => "Spain: Toledo",
		'ES-V'  => "Spain: Valencia / València",
		'ES-VC' => "Spain: Valenciana, Comunidad / Valenciana, Comunitat",
		'ES-VA' => "Spain: Valladolid",
		'ES-BI' => "Spain: Vizcayaa / Bizkaia",
		'ES-ZA' => "Spain: Zamora",
		'ES-Z'  => "Spain: Zaragoza",
		'ES-VI' => "Spain: Álava",
		'ES-AV' => "Spain: Ávila",

		'--GB'   => "", '-GB' => "United Kingdom",
		'GB-ABE' => "United Kingdom: Aberdeen City",
		'GB-ABD' => "United Kingdom: Aberdeenshire",
		'GB-ANS' => "United Kingdom: Angus",
		'GB-ANT' => "United Kingdom: Antrim",
		'GB-ARD' => "United Kingdom: Ards",
		'GB-AGB' => "United Kingdom: Argyll and Bute",
		'GB-ARM' => "United Kingdom: Armagh",
		'GB-BLA' => "United Kingdom: Ballymena",
		'GB-BLY' => "United Kingdom: Ballymoney",
		'GB-BNB' => "United Kingdom: Banbridge",
		'GB-BDG' => "United Kingdom: Barking and Dagenham",
		'GB-BNE' => "United Kingdom: Barnet",
		'GB-BNS' => "United Kingdom: Barnsley",
		'GB-BAS' => "United Kingdom: Bath and North East Somerset",
		'GB-BDF' => "United Kingdom: Bedford",
		'GB-BFS' => "United Kingdom: Belfast",
		'GB-BEX' => "United Kingdom: Bexley",
		'GB-BIR' => "United Kingdom: Birmingham",
		'GB-BBD' => "United Kingdom: Blackburn with Darwen",
		'GB-BPL' => "United Kingdom: Blackpool",
		'GB-BGW' => "United Kingdom: Blaenau Gwent",
		'GB-BOL' => "United Kingdom: Bolton",
		'GB-BMH' => "United Kingdom: Bournemouth",
		'GB-BRC' => "United Kingdom: Bracknell Forest",
		'GB-BRD' => "United Kingdom: Bradford",
		'GB-BEN' => "United Kingdom: Brent",
		'GB-BGE' => "United Kingdom: Bridgend (Pen-y-bont ar Ogwr)",
		'GB-BNH' => "United Kingdom: Brighton and Hove",
		'GB-BST' => "United Kingdom: Bristol, City of",
		'GB-BRY' => "United Kingdom: Bromley",
		'GB-BKM' => "United Kingdom: Buckinghamshire",
		'GB-BUR' => "United Kingdom: Bury",
		'GB-CAY' => "United Kingdom: Caerphilly (Caerffili)",
		'GB-CLD' => "United Kingdom: Calderdale",
		'GB-CAM' => "United Kingdom: Cambridgeshire",
		'GB-CMD' => "United Kingdom: Camden",
		'GB-CRF' => "United Kingdom: Cardiff (Caerdydd)",
		'GB-CMN' => "United Kingdom: Carmarthenshire (Sir Gaerfyrddin)",
		'GB-CKF' => "United Kingdom: Carrickfergus",
		'GB-CSR' => "United Kingdom: Castlereagh",
		'GB-CBF' => "United Kingdom: Central Bedfordshire",
		'GB-CGN' => "United Kingdom: Ceredigion (Sir Ceredigion)",
		'GB-CHE' => "United Kingdom: Cheshire East",
		'GB-CHW' => "United Kingdom: Cheshire West and Chester",
		'GB-CLK' => "United Kingdom: Clackmannanshire",
		'GB-CLR' => "United Kingdom: Coleraine",
		'GB-CWY' => "United Kingdom: Conwy",
		'GB-CKT' => "United Kingdom: Cookstown",
		'GB-CON' => "United Kingdom: Cornwall",
		'GB-COV' => "United Kingdom: Coventry",
		'GB-CGV' => "United Kingdom: Craigavon",
		'GB-CRY' => "United Kingdom: Croydon",
		'GB-CMA' => "United Kingdom: Cumbria",
		'GB-DAL' => "United Kingdom: Darlington",
		'GB-DEN' => "United Kingdom: Denbighshire (Sir Ddinbych)",
		'GB-DER' => "United Kingdom: Derby",
		'GB-DBY' => "United Kingdom: Derbyshire",
		'GB-DRY' => "United Kingdom: Derry",
		'GB-DEV' => "United Kingdom: Devon",
		'GB-DNC' => "United Kingdom: Doncaster",
		'GB-DOR' => "United Kingdom: Dorset",
		'GB-DOW' => "United Kingdom: Down",
		'GB-DUD' => "United Kingdom: Dudley",
		'GB-DGY' => "United Kingdom: Dumfries and Galloway",
		'GB-DND' => "United Kingdom: Dundee City",
		'GB-DGN' => "United Kingdom: Dungannon",
		'GB-DUR' => "United Kingdom: Durham",
		'GB-EAL' => "United Kingdom: Ealing",
		'GB-EAY' => "United Kingdom: East Ayrshire",
		'GB-EDU' => "United Kingdom: East Dunbartonshire",
		'GB-ELN' => "United Kingdom: East Lothian",
		'GB-ERW' => "United Kingdom: East Renfrewshire",
		'GB-ERY' => "United Kingdom: East Riding of Yorkshire",
		'GB-ESX' => "United Kingdom: East Sussex",
		'GB-EDH' => "United Kingdom: Edinburgh, City of",
		'GB-ELS' => "United Kingdom: Eilean Siar",
		'GB-ENF' => "United Kingdom: Enfield",
		'GB-ENG' => "United Kingdom: England",
		'GB-EAW' => "United Kingdom: England and Wales",
		'GB-ESS' => "United Kingdom: Essex",
		'GB-FAL' => "United Kingdom: Falkirk",
		'GB-FER' => "United Kingdom: Fermanagh",
		'GB-FIF' => "United Kingdom: Fife",
		'GB-FLN' => "United Kingdom: Flintshire (Sir y Fflint)",
		'GB-GAT' => "United Kingdom: Gateshead",
		'GB-GLG' => "United Kingdom: Glasgow City",
		'GB-GLS' => "United Kingdom: Gloucestershire",
		'GB-GBN' => "United Kingdom: Great Britain",
		'GB-GRE' => "United Kingdom: Greenwich",
		'GB-GWN' => "United Kingdom: Gwynedd",
		'GB-HCK' => "United Kingdom: Hackney",
		'GB-HAL' => "United Kingdom: Halton",
		'GB-HMF' => "United Kingdom: Hammersmith and Fulham",
		'GB-HAM' => "United Kingdom: Hampshire",
		'GB-HRY' => "United Kingdom: Haringey",
		'GB-HRW' => "United Kingdom: Harrow",
		'GB-HPL' => "United Kingdom: Hartlepool",
		'GB-HAV' => "United Kingdom: Havering",
		'GB-HEF' => "United Kingdom: Herefordshire",
		'GB-HRT' => "United Kingdom: Hertfordshire",
		'GB-HLD' => "United Kingdom: Highland",
		'GB-HIL' => "United Kingdom: Hillingdon",
		'GB-HNS' => "United Kingdom: Hounslow",
		'GB-IVC' => "United Kingdom: Inverclyde",
		'GB-AGY' => "United Kingdom: Isle of Anglesey (Sir Ynys Môn)",
		'GB-IOW' => "United Kingdom: Isle of Wight",
		'GB-ISL' => "United Kingdom: Islington",
		'GB-KEC' => "United Kingdom: Kensington and Chelsea",
		'GB-KEN' => "United Kingdom: Kent",
		'GB-KHL' => "United Kingdom: Kingston upon Hull",
		'GB-KTT' => "United Kingdom: Kingston upon Thames",
		'GB-KIR' => "United Kingdom: Kirklees",
		'GB-KWL' => "United Kingdom: Knowsley",
		'GB-LBH' => "United Kingdom: Lambeth",
		'GB-LAN' => "United Kingdom: Lancashire",
		'GB-LRN' => "United Kingdom: Larne",
		'GB-LDS' => "United Kingdom: Leeds",
		'GB-LCE' => "United Kingdom: Leicester",
		'GB-LEC' => "United Kingdom: Leicestershire",
		'GB-LEW' => "United Kingdom: Lewisham",
		'GB-LMV' => "United Kingdom: Limavady",
		'GB-LIN' => "United Kingdom: Lincolnshire",
		'GB-LSB' => "United Kingdom: Lisburn",
		'GB-LIV' => "United Kingdom: Liverpool",
		'GB-LND' => "United Kingdom: London, City of",
		'GB-LUT' => "United Kingdom: Luton",
		'GB-MFT' => "United Kingdom: Magherafelt",
		'GB-MAN' => "United Kingdom: Manchester",
		'GB-MDW' => "United Kingdom: Medway",
		'GB-MTY' => "United Kingdom: Merthyr Tydfil (Merthyr Tudful)",
		'GB-MRT' => "United Kingdom: Merton",
		'GB-MDB' => "United Kingdom: Middlesbrough",
		'GB-MLN' => "United Kingdom: Midlothian",
		'GB-MIK' => "United Kingdom: Milton Keynes",
		'GB-MON' => "United Kingdom: Monmouthshire (Sir Fynwy)",
		'GB-MRY' => "United Kingdom: Moray",
		'GB-MYL' => "United Kingdom: Moyle",
		'GB-NTL' => "United Kingdom: Neath Port Talbot (Castell-nedd Port Talbot)",
		'GB-NET' => "United Kingdom: Newcastle upon Tyne",
		'GB-NWM' => "United Kingdom: Newham",
		'GB-NWP' => "United Kingdom: Newport (Casnewydd)",
		'GB-NYM' => "United Kingdom: Newry and Mourne",
		'GB-NTA' => "United Kingdom: Newtownabbey",
		'GB-NFK' => "United Kingdom: Norfolk",
		'GB-NAY' => "United Kingdom: North Ayrshire",
		'GB-NDN' => "United Kingdom: North Down",
		'GB-NEL' => "United Kingdom: North East Lincolnshire",
		'GB-NLK' => "United Kingdom: North Lanarkshire",
		'GB-NLN' => "United Kingdom: North Lincolnshire",
		'GB-NSM' => "United Kingdom: North Somerset",
		'GB-NTY' => "United Kingdom: North Tyneside",
		'GB-NYK' => "United Kingdom: North Yorkshire",
		'GB-NTH' => "United Kingdom: Northamptonshire",
		'GB-NIR' => "United Kingdom: Northern Ireland",
		'GB-NBL' => "United Kingdom: Northumberland",
		'GB-NGM' => "United Kingdom: Nottingham",
		'GB-NTT' => "United Kingdom: Nottinghamshire",
		'GB-OLD' => "United Kingdom: Oldham",
		'GB-OMH' => "United Kingdom: Omagh",
		'GB-ORK' => "United Kingdom: Orkney Islands",
		'GB-OXF' => "United Kingdom: Oxfordshire",
		'GB-PEM' => "United Kingdom: Pembrokeshire (Sir Benfro)",
		'GB-PKN' => "United Kingdom: Perth and Kinross",
		'GB-PTE' => "United Kingdom: Peterborough",
		'GB-PLY' => "United Kingdom: Plymouth",
		'GB-POL' => "United Kingdom: Poole",
		'GB-POR' => "United Kingdom: Portsmouth",
		'GB-POW' => "United Kingdom: Powys",
		'GB-RDG' => "United Kingdom: Reading",
		'GB-RDB' => "United Kingdom: Redbridge",
		'GB-RCC' => "United Kingdom: Redcar and Cleveland",
		'GB-RFW' => "United Kingdom: Renfrewshire",
		'GB-RCT' => "United Kingdom: Rhondda, Cynon, Taff (Rhondda, Cynon, Taf)",
		'GB-RIC' => "United Kingdom: Richmond upon Thames",
		'GB-RCH' => "United Kingdom: Rochdale",
		'GB-ROT' => "United Kingdom: Rotherham",
		'GB-RUT' => "United Kingdom: Rutland",
		'GB-SLF' => "United Kingdom: Salford",
		'GB-SAW' => "United Kingdom: Sandwell",
		'GB-SCT' => "United Kingdom: Scotland",
		'GB-SCB' => "United Kingdom: Scottish Borders, The",
		'GB-SFT' => "United Kingdom: Sefton",
		'GB-SHF' => "United Kingdom: Sheffield",
		'GB-ZET' => "United Kingdom: Shetland Islands",
		'GB-SHR' => "United Kingdom: Shropshire",
		'GB-SLG' => "United Kingdom: Slough",
		'GB-SOL' => "United Kingdom: Solihull",
		'GB-SOM' => "United Kingdom: Somerset",
		'GB-SAY' => "United Kingdom: South Ayrshire",
		'GB-SGC' => "United Kingdom: South Gloucestershire",
		'GB-SLK' => "United Kingdom: South Lanarkshire",
		'GB-STY' => "United Kingdom: South Tyneside",
		'GB-STH' => "United Kingdom: Southampton",
		'GB-SOS' => "United Kingdom: Southend-on-Sea",
		'GB-SWK' => "United Kingdom: Southwark",
		'GB-SHN' => "United Kingdom: St. Helens",
		'GB-STS' => "United Kingdom: Staffordshire",
		'GB-STG' => "United Kingdom: Stirling",
		'GB-SKP' => "United Kingdom: Stockport",
		'GB-STT' => "United Kingdom: Stockton-on-Tees",
		'GB-STE' => "United Kingdom: Stoke-on-Trent",
		'GB-STB' => "United Kingdom: Strabane",
		'GB-SFK' => "United Kingdom: Suffolk",
		'GB-SND' => "United Kingdom: Sunderland",
		'GB-SRY' => "United Kingdom: Surrey",
		'GB-STN' => "United Kingdom: Sutton",
		'GB-SWA' => "United Kingdom: Swansea (Abertawe)",
		'GB-SWD' => "United Kingdom: Swindon",
		'GB-TAM' => "United Kingdom: Tameside",
		'GB-TFW' => "United Kingdom: Telford and Wrekin",
		'GB-THR' => "United Kingdom: Thurrock",
		'GB-TOB' => "United Kingdom: Torbay",
		'GB-TOF' => "United Kingdom: Torfaen (Tor-faen)",
		'GB-TWH' => "United Kingdom: Tower Hamlets",
		'GB-TRF' => "United Kingdom: Trafford",
		'GB-UKM' => "United Kingdom: United Kingdom",
		'GB-VGL' => "United Kingdom: Vale of Glamorgan, The (Bro Morgannwg)",
		'GB-WKF' => "United Kingdom: Wakefield",
		'GB-WLS' => "United Kingdom: Wales",
		'GB-WLL' => "United Kingdom: Walsall",
		'GB-WFT' => "United Kingdom: Waltham Forest",
		'GB-WND' => "United Kingdom: Wandsworth",
		'GB-WRT' => "United Kingdom: Warrington",
		'GB-WAR' => "United Kingdom: Warwickshire",
		'GB-WBK' => "United Kingdom: West Berkshire",
		'GB-WDU' => "United Kingdom: West Dunbartonshire",
		'GB-WLN' => "United Kingdom: West Lothian",
		'GB-WSX' => "United Kingdom: West Sussex",
		'GB-WSM' => "United Kingdom: Westminster",
		'GB-WGN' => "United Kingdom: Wigan",
		'GB-WNM' => "United Kingdom: Windsor and Maidenhead",
		'GB-WRL' => "United Kingdom: Wirral",
		'GB-WOK' => "United Kingdom: Wokingham",
		'GB-WLV' => "United Kingdom: Wolverhampton",
		'GB-WOR' => "United Kingdom: Worcestershire",
		'GB-WRX' => "United Kingdom: Wrexham (Wrecsam)",
		'GB-YOR' => "United Kingdom: York",

		'--US'  => "", '-US' => "United States",
		'US-AL' => "United States: Alabama",
		'US-AK' => "United States: Alaska",
		'US-AS' => "United States: American Samoa, Samoa Americana",
		'US-AZ' => "United States: Arizona",
		'US-AR' => "United States: Arkansas",
		'US-CA' => "United States: California",
		'US-CO' => "United States: Colorado",
		'US-CT' => "United States: Connecticut",
		'US-DE' => "United States: Delaware",
		'US-DC' => "United States: District of Columbia, Disricte de Columbia",
		'US-FL' => "United States: Florida",
		'US-GA' => "United States: Georgia, Geòrgia",
		'US-GU' => "United States: Guam",
		'US-HI' => "United States: Hawaii",
		'US-ID' => "United States: Idaho",
		'US-IL' => "United States: Illinois",
		'US-IN' => "United States: Indiana",
		'US-IA' => "United States: Iowa",
		'US-KS' => "United States: Kansas",
		'US-KY' => "United States: Kentucky",
		'US-LA' => "United States: Louisiana",
		'US-ME' => "United States: Maine",
		'US-MD' => "United States: Maryland",
		'US-MA' => "United States: Massachusetts",
		'US-MI' => "United States: Michigan",
		'US-MN' => "United States: Minnesota",
		'US-MS' => "United States: Mississippi",
		'US-MO' => "United States: Missouri",
		'US-MT' => "United States: Montana",
		'US-NE' => "United States: Nebraska",
		'US-NV' => "United States: Nevada",
		'US-NH' => "United States: New Hampshire",
		'US-NJ' => "United States: New Jersey",
		'US-NM' => "United States: New Mexico",
		'US-NY' => "United States: New York",
		'US-NC' => "United States: North Carolina",
		'US-ND' => "United States: North Dakota",
		'US-MP' => "United States: Northern Mariana Islands, Illes Marianes del Nord",
		'US-OH' => "United States: Ohio",
		'US-OK' => "United States: Oklahoma",
		'US-OR' => "United States: Oregon",
		'US-PA' => "United States: Pennsylvania",
		'US-PR' => "United States: Puerto Rico",
		'US-RI' => "United States: Rhode Island",
		'US-SC' => "United States: South Carolina",
		'US-SD' => "United States: South Dakota",
		'US-TN' => "United States: Tennessee",
		'US-TX' => "United States: Texas",
		'US-UM' => "United States: United States Minor Outlying Islands, Illes Perifèriques Menors dels EUA",
		'US-UT' => "United States: Utah",
		'US-VT' => "United States: Vermont",
		'US-VI' => "United States: Virgin Islands, Illes Verge",
		'US-VA' => "United States: Virginia",
		'US-WA' => "United States: Washington",
		'US-WV' => "United States: West Virginia",
		'US-WI' => "United States: Wisconsin",
		'US-WY' => "United States: Wyoming",

		'--VN'  => "", '-VN' => "Vietnam",
		'VN-44' => "Vietnam: An Giang",
		'VN-43' => "Vietnam: Bà Rịa - Vũng Tàu",
		'VN-57' => "Vietnam: Bình Dương",
		'VN-58' => "Vietnam: Bình Phước",
		'VN-40' => "Vietnam: Bình Thuận",
		'VN-31' => "Vietnam: Bình Định",
		'VN-55' => "Vietnam: Bạc Liêu",
		'VN-54' => "Vietnam: Bắc Giang",
		'VN-53' => "Vietnam: Bắc Kạn",
		'VN-56' => "Vietnam: Bắc Ninh",
		'VN-50' => "Vietnam: Bến Tre",
		'VN-04' => "Vietnam: Cao Bằng",
		'VN-59' => "Vietnam: Cà Mau",
		'VN-48' => "Vietnam: Cần Thơ",
		'VN-30' => "Vietnam: Gia Lai",
		'VN-14' => "Vietnam: Hoà Bình",
		'VN-03' => "Vietnam: Hà Giang",
		'VN-63' => "Vietnam: Hà Nam",
		'VN-64' => "Vietnam: Hà Nội, thủ đô",
		'VN-15' => "Vietnam: Hà Tây",
		'VN-23' => "Vietnam: Hà Tỉnh",
		'VN-66' => "Vietnam: Hưng Yên",
		'VN-61' => "Vietnam: Hải Duong",
		'VN-62' => "Vietnam: Hải Phòng, thành phố",
		'VN-73' => "Vietnam: Hậu Giang",
		'VN-65' => "Vietnam: Hồ Chí Minh, thành phố [Sài Gòn]",
		'VN-34' => "Vietnam: Khánh Hòa",
		'VN-47' => "Vietnam: Kiên Giang",
		'VN-28' => "Vietnam: Kon Tum",
		'VN-01' => "Vietnam: Lai Châu",
		'VN-41' => "Vietnam: Long An",
		'VN-02' => "Vietnam: Lào Cai",
		'VN-35' => "Vietnam: Lâm Đồng",
		'VN-09' => "Vietnam: Lạng Sơn",
		'VN-67' => "Vietnam: Nam Định",
		'VN-22' => "Vietnam: Nghệ An",
		'VN-18' => "Vietnam: Ninh Bình",
		'VN-36' => "Vietnam: Ninh Thuận",
		'VN-68' => "Vietnam: Phú Thọ",
		'VN-32' => "Vietnam: Phú Yên",
		'VN-24' => "Vietnam: Quảng Bình",
		'VN-27' => "Vietnam: Quảng Nam",
		'VN-29' => "Vietnam: Quảng Ngãi",
		'VN-13' => "Vietnam: Quảng Ninh",
		'VN-25' => "Vietnam: Quảng Trị",
		'VN-52' => "Vietnam: Sóc Trăng",
		'VN-05' => "Vietnam: Sơn La",
		'VN-21' => "Vietnam: Thanh Hóa",
		'VN-20' => "Vietnam: Thái Bình",
		'VN-69' => "Vietnam: Thái Nguyên",
		'VN-26' => "Vietnam: Thừa Thiên-Huế",
		'VN-46' => "Vietnam: Tiền Giang",
		'VN-51' => "Vietnam: Trà Vinh",
		'VN-07' => "Vietnam: Tuyên Quang",
		'VN-37' => "Vietnam: Tây Ninh",
		'VN-49' => "Vietnam: Vĩnh Long",
		'VN-70' => "Vietnam: Vĩnh Phúc",
		'VN-06' => "Vietnam: Yên Bái",
		'VN-71' => "Vietnam: Điện Biên",
		'VN-60' => "Vietnam: Đà Nẵng, thành phố",
		'VN-33' => "Vietnam: Đắc Lắk",
		'VN-72' => "Vietnam: Đắk Nông",
		'VN-39' => "Vietnam: Đồng Nai",
		'VN-45' => "Vietnam: Đồng Tháp",
	];

}
